	function [res1, res2] = LATTICE_2_S(P, wT, icase)
	
	% After knowing the poles included in P, [S1, S2] = LATTICE_2_S(P, wT, 1) 
	% evaluated the frequency responses of two allpass filters in a lowpass 
	% (LP)- highpass (HP) lattice wave digital (LWD) filter pair at angular 
	% frequencies included in w. It is assumed that the poles can be shared 
	% between two allpass filters in the conventional manner.
	
	% [res_LP, res_HP] = LATTICE_2_S(P, wT, 2), in turn, evaluates both the LP and
	% HP frequency responses. res_HP is not unique because it the difference
	% between the responses of two allpass filters. The magnitude part is the
	% same in both options and only the phase part differs.
	 
	% 	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 		Tapio Saramki 8.5.2018
	% 	Modified by: 	LW 2018-06-25
	% 	Copyright:		by authors - not released for commercial use
	% 	Version 		1
	% 	Report bugs to:	Wanhammar@gmail.com
	
	[Y,ind] = sort(angle(P));
	P = P(ind);
	P1 = P(1:2:length(P));
	P2 = P(2:2:length(P));
	S1 = ones(1,length(w));
	expwT = exp(j*wT);
	for n = 1:length(P1)
	  S1 = S1.*(-P1(n)+expwT)./(1-P1(n)*expwT);
	end
	S2 = ones(1,length(wT));
	for n = 1:length(P2)
	  S2 = S2.*(-P2(n)+expwT)./(1-P2(n)*expwT);
	end
	if icase == 1
	  res1 = S1;
	  res2 = S2;
	elseif icase == 2
	  res1 = (S1+S2)/2;
	  res2 = (S1-S2)/2;
	end
